/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console;

import filenet.sim.api.IVWSIMScenario;
import filenet.sim.api.IVWSIMSimulation;
import filenet.sim.api.VWSIMDocumentRefreshException;
import filenet.sim.api.VWSIMSession;
import filenet.sim.api.VWSIMSimulationVerifyException;
import filenet.sim.api.VWScenarioDefinition;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMConsoleRootNode;
import filenet.sim.toolkit.console.VWSIMFolderNode;
import filenet.sim.toolkit.console.VWSIMScenarioNode;
import filenet.sim.toolkit.console.VWSIMSimulationLaunchResult;
import filenet.sim.toolkit.console.VWSIMSimulationNode;
import filenet.sim.toolkit.console.property.VWSIMPublishedDataDialog;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.sim.toolkit.utils.VWSIMHelp;
import filenet.sim.toolkit.utils.VWSIMLauncher;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMAttachment;
import filenet.vw.idm.toolkit.IVWIDMDialog;
import filenet.vw.idm.toolkit.IVWIDMFactory;
import filenet.vw.idm.toolkit.IVWIDMFolder;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.idm.toolkit.VWIDMBaseFactory;
import filenet.vw.toolkit.utils.IVWAppLauncher;
import filenet.vw.toolkit.utils.IVWLaunchableApp;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import javax.swing.JApplet;
import javax.swing.JOptionPane;

public class VWSIMConsolePerformer {
    public static final int STATUS_SUCCESS = 0;
    public static final int STATUS_FAILED = -1;
    public static final int STATUS_CANCELED = 1;
    private static final int OPTION_YES_NO = 1;
    private static final int OPTION_COMMIT_DISCARD = 2;
    private static final int OPTION_COMMIT_DISCARD_CANCEL = 3;
    private static final int DEFAULT_OPTION_YES = 0;
    private static final int DEFAULT_OPTION_NO = 1;
    private static final int DEFAULT_OPTION_COMMIT = 0;
    private static final int DEFAULT_OPTION_DISCARD = 1;
    private static final int DEFAULT_OPTION_CANCEL = 2;
    private static final Object[] OptionsYesNo = new Object[]{VWSIMResource.Yes, VWSIMResource.No};
    private Container m_mainContainer = null;
    private Frame m_parentFrame = null;
    private JApplet m_parentApplet = null;
    private Object m_client;
    private String m_title = null;
    private VWSession m_vwSession = null;
    private VWSessionInfo m_vwSessionInfo = null;
    private VWSIMSession m_simSession = null;

    public VWSIMConsolePerformer(Object client, Container mainContainer, Frame parentFrame, JApplet parentApplet, VWSession vwSession, VWSIMSession simSession) {
        try {
            this.m_client = client;
            this.m_vwSession = vwSession;
            this.m_simSession = simSession;
            this.m_mainContainer = mainContainer;
            this.m_parentFrame = parentFrame;
            this.m_parentApplet = parentApplet;
            this.m_title = VWIDMBaseFactory.instance().getVWString(4).toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void messageOptionDialog(String msgString, String titleString, int option) {
        Container parentComp = this.m_mainContainer;
        if (this.m_mainContainer instanceof JApplet && this.m_mainContainer != null && !((JApplet)this.m_mainContainer).isActive()) {
            parentComp = null;
        }
        String title = titleString;
        switch (option) {
            case 0: {
                if (title == null) {
                    title = VWSIMResource.ErrorMessage;
                }
                JOptionPane.showMessageDialog(parentComp, msgString, title, 0);
                break;
            }
            case -1: 
            case 1: 
            case 2: 
            case 3: {
                if (title == null) {
                    title = this.m_title;
                }
                JOptionPane.showMessageDialog(parentComp, msgString, title, option);
                break;
            }
            default: {
                if (title == null) {
                    title = this.m_title;
                }
                JOptionPane.showMessageDialog(parentComp, msgString, title, -1);
            }
        }
    }

    public void performHelp(VWSIMBaseNode focus) {
        String helpPage = VWSIMHelp.Help_Simulation_Config + "_start_here_console.htm";
        if (focus != null) {
            switch (focus.getType()) {
                case 17: {
                    helpPage = VWSIMHelp.Help_Simulation_Config + "simconsoleroot.htm";
                    break;
                }
                case 33: {
                    helpPage = VWSIMHelp.Help_Simulation_Config + "simconsolescenario.htm";
                    break;
                }
                case 18: {
                    helpPage = VWSIMHelp.Help_Simulation_Config + "simconsoletopfolder.htm";
                    break;
                }
                case 16: {
                    helpPage = VWSIMHelp.Help_Simulation_Config + "simconsolefolder.htm";
                    break;
                }
                case 34: {
                    helpPage = VWSIMHelp.Help_Simulation_Config + "simconsolesimulation.htm";
                }
            }
        }
        VWSIMHelp.displayPage(helpPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VWSIMSimulationLaunchResult launchSimulation(VWSIMBaseNode aNode) {
        VWSIMSimulationLaunchResult result = null;
        try {
            VWSIMFolderNode parentFolder;
            IVWIDMItem parentFolderItem;
            IVWSIMScenario aIVWScn;
            VWScenarioDefinition aScnDef;
            VWSIMLauncher aSimLauncher;
            if (aNode.getType() != 33) {
                VWSIMSimulationLaunchResult vWSIMSimulationLaunchResult = result;
                return vWSIMSimulationLaunchResult;
            }
            this.m_parentFrame.setCursor(new Cursor(3));
            VWSIMScenarioNode aScnNode = (VWSIMScenarioNode)aNode;
            if (this.validateScenarioDefinition(aScnNode) && (aSimLauncher = new VWSIMLauncher(this.m_parentFrame, this.m_vwSession)).startSimulation(aScnDef = aScnNode.getScenarioDefinition(), aIVWScn = aScnNode.getSIMScenario(), parentFolderItem = (parentFolder = (VWSIMFolderNode)aScnNode.getParent()).getIdmItem())) {
                if (aSimLauncher.getSimulationStatus() == -1) {
                    String errMsg = aSimLauncher.getSimulationFailureMessage();
                    aNode.displayMessage(3, errMsg);
                    VWMessageDialog.showOptionDialog(this.m_parentFrame, errMsg, 1);
                } else {
                    IVWIDMFolder[] folderLis = aSimLauncher.getFoldersFiledIn();
                    IVWSIMSimulation theSimulation = aSimLauncher.getSimulation();
                    result = new VWSIMSimulationLaunchResult(theSimulation, folderLis);
                    aNode.displayMessage(1, VWSIMResource.StartSimulationMsg.toString(aSimLauncher.getSimulationName(), aSimLauncher.getSimulationId()));
                }
            }
            this.m_parentFrame.setCursor(new Cursor(0));
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
            aNode.displayMessage(3, ex.getLocalizedMessage());
            VWDebug.logException(ex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.m_parentFrame.setCursor(new Cursor(0));
        }
        return result;
    }

    public void stopSimulation(VWSIMBaseNode aNode) {
        if (aNode.getType() != 34) {
            return;
        }
        VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)aNode;
        try {
            aSimNode.stopSimulation();
            aSimNode.refresh();
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
            aNode.displayMessage(3, ex.getLocalizedMessage());
            VWDebug.logException(ex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public boolean validateScenarioDefinition(VWSIMScenarioNode aScnNode) {
        boolean bRet = false;
        try {
            int errLevel = aScnNode.validateScenarioDefinition();
            if (errLevel == 3) {
                String errMsg = VWSIMResource.ScenarioValidationError.toString(aScnNode.getName());
                VWMessageDialog.showOptionDialog(this.m_parentFrame, errMsg, 1);
            } else if (errLevel == 2) {
                String errMsg = VWSIMResource.ScenarioValidationWarning.toString(aScnNode.getName());
                int ret = VWMessageDialog.showOptionDialog(this.m_parentFrame, errMsg, VWSIMResource.s_warning, 3, 3, null, 0, 0);
                if (ret <= 1) {
                    bRet = true;
                }
            } else {
                bRet = true;
            }
        }
        catch (Exception ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
        return bRet;
    }

    public void viewAnimation(VWSIMBaseNode aBaseNode) throws Exception {
        if (this.m_vwSessionInfo == null) {
            this.m_vwSessionInfo = new VWSessionInfo(this.m_mainContainer, this.m_parentApplet, this.m_vwSession);
        }
        VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)aBaseNode;
        try {
            IVWSIMSimulation aIVWSimulation = aSimNode.getSIMSimulation();
            aIVWSimulation.refresh();
            aIVWSimulation.verify();
            String docId = aSimNode.getDocID();
            String libId = aSimNode.getLibraryId();
            this.m_vwSessionInfo.setIDMInfo(libId, null, docId);
            this.launchApplication("filenet.sim.apps.viewer.VWSIMAnimatorApplication");
        }
        catch (VWSIMDocumentRefreshException refEx) {
            String msg = VWSIMResource.FailedToAccessSimulationDoRefresh.toString(aSimNode.getName());
            this.messageOptionDialog(msg, VWSIMResource.ErrorMessage, 0);
        }
        catch (VWSIMSimulationVerifyException verifyEx) {
            throw verifyEx;
        }
        catch (VWException ex) {
            VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
            VWDebug.logException(ex);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void launchScenarioDesigner(VWSIMBaseNode aBaseNode) {
        try {
            if (this.m_vwSessionInfo == null) {
                this.m_vwSessionInfo = new VWSessionInfo(this.m_mainContainer, this.m_parentApplet, this.m_vwSession);
            }
            Object docId = null;
            Object libId = null;
            IVWIDMItem idmItem = null;
            switch (aBaseNode.getType()) {
                case 34: {
                    VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)aBaseNode;
                    VWScenarioDefinition scnDef = aSimNode.getSIMScenarioDefinition();
                    StringBuffer runtimeXML = new StringBuffer();
                    scnDef.toXML(runtimeXML);
                    this.m_vwSessionInfo.setProperty("ScenarioXML", runtimeXML.toString());
                    this.m_vwSessionInfo.setProperty("ScenarioDesignerInvokeType", "2");
                    break;
                }
                case 33: {
                    idmItem = aBaseNode.getIdmItem();
                    this.m_vwSessionInfo.setProperty("DocumentCanonicalId", idmItem.getCanonicalName());
                    this.m_vwSessionInfo.setProperty("ScenarioDesignerInvokeType", "1");
                    break;
                }
                case 16: 
                case 18: {
                    idmItem = aBaseNode.getIdmItem();
                    this.m_vwSessionInfo.setProperty("DocumentCanonicalId", idmItem.getCanonicalName());
                    this.m_vwSessionInfo.setProperty("ScenarioDesignerInvokeType", "0");
                    break;
                }
                case 17: {
                    this.m_vwSessionInfo.setProperty("DocumentCanonicalId", null);
                    this.m_vwSessionInfo.setProperty("ScenarioDesignerInvokeType", "0");
                }
            }
            this.launchApplication("filenet.sim.apps.designer.VWSIMDesignerApplication");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean launchApplication(String className) {
        try {
            if (this.m_vwSessionInfo == null) {
                return false;
            }
            ClassLoader loader = this.getClass().getClassLoader();
            Object processor = loader.loadClass(className).newInstance();
            if (processor != null) {
                if (processor instanceof IVWLaunchableApp) {
                    ((IVWLaunchableApp)processor).init(this.m_vwSessionInfo);
                    if (this.m_mainContainer instanceof IVWAppLauncher) {
                        ((IVWAppLauncher)((Object)this.m_mainContainer)).registerApplication((IVWLaunchableApp)processor);
                    }
                }
                return true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return false;
    }

    public void newScenario(VWSIMBaseNode aNode) {
        VWSIMFolderNode aFolderNode = null;
        switch (aNode.getType()) {
            case 33: {
                VWSIMScenarioNode aScnNode = (VWSIMScenarioNode)aNode;
                aFolderNode = (VWSIMFolderNode)aScnNode.getParent();
                break;
            }
            case 34: {
                VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)aNode;
                aFolderNode = (VWSIMFolderNode)aSimNode.getParent();
                break;
            }
            default: {
                aFolderNode = (VWSIMFolderNode)aNode;
            }
        }
        this.launchScenarioDesigner(aFolderNode);
    }

    public boolean performDelete(VWSIMBaseNode aNode) {
        boolean bRet = false;
        try {
            String msg = null;
            switch (aNode.getType()) {
                case 33: {
                    msg = VWSIMResource.ConfirmDeleteScenario.toString(aNode.getName());
                    if (VWMessageDialog.showConfirmDialog(this.m_parentFrame, msg, VWSIMResource.SelectAnOption, 3) != 1) break;
                    VWSIMScenarioNode aScnNode = (VWSIMScenarioNode)aNode;
                    try {
                        aScnNode.deleteScenario();
                        bRet = true;
                    }
                    catch (Exception ex) {
                        VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
                        VWDebug.logException(ex);
                    }
                    break;
                }
                case 34: {
                    VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)aNode;
                    msg = aSimNode.getStatus() == 1 ? VWSIMResource.ConfirmDeleteSimulationRun.toString(aNode.getName()) : VWSIMResource.ConfirmDeleteSimulation.toString(aNode.getName());
                    if (VWMessageDialog.showConfirmDialog(this.m_parentFrame, msg, VWSIMResource.SelectAnOption, 3) != 1) break;
                    try {
                        aSimNode.deleteSimulation();
                        bRet = true;
                    }
                    catch (Exception ex) {
                        VWMessageDialog.showOptionDialog(this.m_parentFrame, ex.getLocalizedMessage(), 1);
                        VWDebug.logException(ex);
                    }
                    break;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return bRet;
    }

    public void publishedData() {
        this.m_parentFrame.setCursor(new Cursor(3));
        VWSIMPublishedDataDialog publishedData = new VWSIMPublishedDataDialog(this.m_parentFrame, this.m_vwSession, this.m_simSession);
        this.m_parentFrame.setCursor(new Cursor(0));
        publishedData.show();
        publishedData.releaseResources();
        publishedData.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performProperties(VWSIMBaseNode aNode) {
        try {
            IVWIDMItem aIDMItem = aNode.getIdmItem();
            if (aIDMItem == null) return;
            IVWIDMAttachment aIDMAttachment = aIDMItem.getAttachment();
            if (aIDMAttachment == null) return;
            this.m_parentFrame.setCursor(new Cursor(3));
            aIDMAttachment.showPropertiesDialog();
            this.m_parentFrame.setCursor(new Cursor(0));
            switch (aNode.getType()) {
                case 34: {
                    VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)aNode;
                    aSimNode.refresh();
                    return;
                }
                case 33: {
                    VWSIMScenarioNode aScnNode = (VWSIMScenarioNode)aNode;
                    aScnNode.refresh();
                    return;
                }
            }
            return;
        }
        catch (VWSIMSimulationVerifyException refEx) {
            this.messageOptionDialog(refEx.getLocalizedMessage(), VWSIMResource.ErrorMessage, 0);
            return;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return;
        }
        finally {
            this.m_parentFrame.setCursor(new Cursor(0));
        }
    }

    public boolean performMapCeFolder(VWSIMBaseNode aNode) {
        boolean bRet = false;
        try {
            if (aNode.getType() == 17) {
                IVWIDMFactory idmFactory = VWIDMBaseFactory.instance();
                IVWIDMDialog idmDialog = idmFactory.getBrowseDialog(null, 2, VWSIMResource.s_select_withHK, null);
                idmDialog.setButtonText(VWSIMResource.s_select_withHK);
                idmDialog.setButtonTooltip(VWSIMResource.s_select);
                idmDialog.showDialog(this.m_parentFrame);
                IVWIDMItem idmItem = idmDialog.getSelectedItem();
                if (idmItem != null) {
                    VWSIMConsoleRootNode rnode = (VWSIMConsoleRootNode)aNode;
                    if (rnode.mappedFolderIndex(idmItem) >= 0) {
                        this.messageOptionDialog(VWSIMResource.FolderHasBeenMapped.toString(idmItem.getLabel()), VWSIMResource.ErrorMessage, 0);
                    } else {
                        bRet = rnode.addMappedFolder(idmItem);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            this.messageOptionDialog(ex.getLocalizedMessage(), VWSIMResource.ErrorMessage, 0);
        }
        return bRet;
    }

    public void releaseResources() {
        this.m_mainContainer = null;
        this.m_parentFrame = null;
        this.m_parentApplet = null;
        this.m_client = null;
        this.m_title = null;
        this.m_vwSession = null;
        this.m_vwSessionInfo = null;
        this.m_simSession = null;
    }
}

